#!/bin/bash
sampleID=$1
fq1=$2
fq2=$3
sampleDir=$4
SMID=$5
ref=/data/fs09/wangzf/nanopore/ztf/HCC/ref/hg38_mainChr.fa
#files configure
logfile=${sampleDir}/${sampleID}_BWA_mapping_pipeline.log
sam=${sampleDir}/${sampleID}.sam
bam=${sampleDir}/${sampleID}.bam
bam_sort=${sampleDir}/${sampleID}.sorted.bam
#index
#nohup /data/fs01/biosoft/bwa-0.7.17/bwa index -a bwtsw hg38_mainChr.fa &
#mapping
echo "$(date) 1. mapping start: $sampleID" >> "$logfile"
/data/fs01/biosoft/bwa-0.7.17/bwa mem -M -Y -t 38 -R "@RG\tID:${sampleID}\tSM:${SMID}\tLB:WGS\tPL:Illumina\tCN:SCUZTF" $ref "$fq1" "$fq2" > "$sam"
echo "$(date) 1. mapping finished: $sampleID" >> "$logfile"
#sam2bam
echo "$(date) 2. sam2bam start: $sampleID" >> "$logfile"
/data/fs01/biosoft/samtools-1.9/samtools view -@ 38 -bS "$sam" > "$bam"
echo "$(date) 2. sam2bam finished: $sampleID" >> "$logfile"
#sortbam
echo "$(date) 3. sortbam start: $sampleID" >> "$logfile"
/data/fs01/biosoft/samtools-1.9/samtools sort -@ 38 "$bam" > "$bam_sort"
echo "$(date) 3. sortbam finished: $sampleID" >> "$logfile"
#indexbam
echo "$(date) 4. indexbam start: $sampleID" >> "$logfile"
/data/fs01/biosoft/samtools-1.9/samtools index -@ 38 "$bam_sort"
echo "$(date) 4. indexbam finished: $sampleID" >> "$logfile"
rm "$sam"
rm "$bam"
echo "$(date) 5. rm sam finished: $sampleID" >> "$logfile"